      PRogram main                                                      
C     PROGRAM PLOTGEN(INPUT,OUTPUT,PLOT,RHO,TAPE5=INPUT,TAPE6=          
C    *OUTPUT,TAPE20=PLOT,TAPE10=RHO,TAPE11)                             
      PARAMETER (NXDIM=200)                                             
      PARAMETER (NYDIM=150)                                             
      COMMON /COM/ CHGMAX,SCALE,chgmin                                  
      DIMENSION CHG(NXDIM,NYDIM),TITEL(15),ATL(50),ch1(nxdim,nydim)     
      INTEGER status                                                   
      character fname*80,pfname*80,ifname*80,rfname*80                                                
      character titel*1,plotn*5,inputn*6,rhon*4                                                 
      DATA TITEL,plotn,inputn,rhon/15*' ','.plot','.input','.rho'/                                                
c
  334 format(a80)                                                       
  112 FORMAT(F5.2,/,2F10.5)                                        
  113 FORMAT('   SCALE:',F5.2,'    CHGMIN-MAX:',2F10.5)          
c                                                                       
      write(*,*) 'enter filename: (implies fn.plot, .input, .rho)'                     
      read(*,334) fname
      do 50 i=1,80
  50  if(fname(i:i).eq.' ') goto 51
  51  continue
      pfname=fname
      rfname=fname
      ifname=fname
      ifname(i:i+5)=inputn                                                  
      rfname(i:i+3)=rhon                                                  
      pfname(i:i+4)=plotn                                                  
c      open(55,file=ifname,status='old')                                 
      open(66,file='plotgenc.output')                                             
c      READ (55,112) SCALE,CHGMIN,CHGMAX                           
      scale=1.d0
      chgmin=-99999.d0       
      chgmax=-99999.d0       
      WRITE(66,113) SCALE,CHGMIN,CHGMAX                           
c                                                                       
      open(10,file=rfname,status='old')                                
      open(11,file='rho1',status='old',iostat=iot,err=3)              
 3    READ(10,*) NPX,NPY,RELX,RELY                                      
      if(iot.eq.0) READ(11,*,END=987) NPX,NPY,RELX,RELY                 
c      write(*,*) 'iot file 11=',iot                                     
      if(iot.ne.0) iot=-1                                               
  987 RELX=RELX*SCALE                                                   
      RELY=RELY*SCALE                                                   
      write(*,*) ' scale:',scale                       
c      DO 1 I=1,NPX                                                     
c      DO 1 J=1,NPY,8                                                   
c        j2=j+min0(j+7,npy)                                             
       READ(10,333) ((CHG(I,J1),j1=1,npy),i=1,npx)                      
c       write(*,*)'read',i                                               
        IF(IOT.LT.0) GOTO 1                                             
         READ(11,333) ((CH1(i,j1),j1=1,npy),i=1,npx)                    
 333    format(5e16.8)                                                  
        do 2 i=1,npx                                                    
        do 2 j1=1,npy                                                   
   2    CHG(I,J1)=CHG(I,J1)-CH1(i,j1)                                   
   1    CONTINUE                                                        
       close (10)                                                       
       close(11)                                                        
   10 FORMAT(1H0,13(10F12.5,/))                                         
   11 FORMAT(5X,I3)                                                     
   12 FORMAT(8F10.5)                                                    
c      READ(55,11) ILIN
      ilin=1                                                   
      IF(ILIN.EQ.1) THEN                                                
      ILIN=1                                                            
      CMIN=-1.                                                          
      CMAX=2.                                                           
      DELTA=0.1                                                         
      ELSE IF(ILIN.EQ.0) THEN                                           
      CMIN=-0.5                                                         
      CMAX=1.                                                           
      DELTA=0.05                                                        
      ILIN=1                                                            
      ELSE IF(ILIN.LT.0) THEN                                           
      ILIN=IABS(ILIN)                                                   
      SQ2=SQRT(2.)                                                      
      READ(55,12)A0                                                      
      DO 20 I=1,ILIN                                                    
  20  ATL(I)=A0*SQ2**(I-1)                                              
      ELSE IF(ILIN.EQ.999) THEN                                         
      READ(55,*) AM,AD,AMA                                               
      I=1                                                               
      ATL(1)=AM                                                         
   35 ATL(I+1)=ATL(I)+AD                                                
      I=I+1                                                             
      IF(ATL(I).LE.AMA) GOTO 35                                         
      ILIN=I-1                                                          
      ELSE                                                              
      READ(55,*) (ATL(I),I=1,ILIN)                                       
      END IF                                                            
         DO 36 I=1,ILIN                                                 
  36  IF(ABS(ATL(I)).LT.1.E-6) ATL(I)=0.0                               
 46   continue
      call savecl
      call psinit(pfname)                       
      CALL GRAFKH(CHG,NXDIM,NYDIM,NPX,NPY,TITEL,ILIN,CMIN,CMAX,DELTA,   
     *ATL,ILIN,RELX,RELY,0,0.0,0.0,0,0.0,0.0,1,1,0)                     
      goto 40
 41   write(*,*) 'relx, rely (scale) =',relx,rely,scale                 
 40   write(*,*) 'ilin=',ilin                                          
      write(*,*) 'atl=',(atl(i),i=1,ilin)                               
      write(*,*)
      write(*,*) '    select 1 to rescale'
      write(*,*) '           2 to change ilin'
      write(*,*) '           3 to replot '
      write(*,*) '           4 to label plot '
      write(*,*) '        or 0 to end'             
      read(*,*) is                                                 
      if(is.eq.1) then  
        relx=relx/scale
        rely=rely/scale                                                
        write(*,*) 'scale:'
        read(*,*) scale    
        relx=relx*scale
        rely=rely*scale                                         
        goto 41                                                         
      else if(is.eq.2) then                                             
        write(*,*) 'ilin=  1:    -1.0, 0.10, 2.'                        
        write(*,*) 'ilin=  0:    -0.5, 0.05, 1.'                        
        write(*,*) 'ilin= 999:   amin, adelta, amax'                    
        write(*,*) 'ilin=   i:   specify i contour values'                   
        write(*,*) 'ilin=  -i:   i lines with a0*sqrt( 2 )'           
        write(*,*) 'ilin= 888:   i lines with +-a0*sqrt( 2 )'         
        read(*,*)ilin                                                   
      IF(ILIN.EQ.1) THEN                                                
      ILIN=1                                                            
      CMIN=-1.                                                          
      CMAX=2.                                                           
      DELTA=0.1                                                         
      ELSE IF(ILIN.EQ.0) THEN                                           
      CMIN=-0.5                                                         
      CMAX=1.                                                           
      DELTA=0.05                                                        
      ILIN=1                                                            
      ELSE IF(ILIN.LT.0) THEN                                           
      ILIN=IABS(ILIN)                                                   
      SQ2=SQRT(2.)                                                      
      write(*,*) 'start with:'                                          
      READ(*,12) A0                                                     
      DO 42 I=1,ILIN                                                    
  42  ATL(I)=A0*SQ2**(I-1)                                              
      ELSE IF(ILIN.eq.888) THEN 
         atl(1)=0.0
      write(*,*) 'number of lines:'
      read(*,*) ilin                                          
      SQ2=SQRT(2.)                                                      
      write(*,*) 'start with:'                                          
      READ(*,12) A0                                                     
      DO 420 I=1,ILIN                                                    
 420     ATL(I+1)=A0*SQ2**(I-1)
      do     i=1,ilin
         atl(ilin+i+1)=-a0*SQ2**(I-1)
      enddo
         atl(2*ilin+2)=0.0
         ilin=2*ilin+2                                             
      ELSE IF(ILIN.EQ.999) THEN                                         
      READ(*,*) AM,AD,AMA                                               
      I=1                                                               
      ATL(1)=AM                                                         
   43 ATL(I+1)=ATL(I)+AD                                                
      I=I+1                                                             
      IF(ATL(I).LE.AMA) GOTO 43                                         
      ILIN=I-1                                                          
      ELSE                                                              
      READ(*,*) (ATL(I),I=1,ILIN)                                       
      END IF                                                            
         DO 44 I=1,ILIN                                                 
  44  IF(ABS(ATL(I)).LT.1.E-6) ATL(I)=0.0                               
        goto 41                                                         
      else if(is.eq.3) then                                             
      call closesc
      call psclos 
      goto 46                                                           
      else if(is.eq.4) then                                             
      call dirpl
      goto 41                                                         
      end if                                                            
      call closesc
      call psclos 
      stop                                                            
      END                                                               
      SUBROUTINE GRAFKH(F,NMAX,MMAX,N,M,TITL,ILIN,FMIN0,FMAX0,          
     1 DELTA,ATL,IDEF,RELX,RELY,IZERP,XZERP,YZERP,IZERC,XZERC,          
     2 YZERC,KPRINT,KPLOT,KCLOUD)                                       
C                                                                       
C    GRAPHICS SUBROUTINE PACKAGE  WRITTEN BY K. HERMANN                 
C    TECHNICAL UNIVERSITY CLAUSTHAL  DECEMBER 1980                      
C                                                                       
C    3 RD VERSION     PARAMETERS :                                      
C                                                                       
C    F(I,K)      I=1...N (X DIRECTION)   ARRAY TO BE PLOTTED            
C                K=1...M (Y DIRECTION)                                  
C                                                                       
C    NMAX,MMAX   DEFINED DIMENSIONS OF THE ARRAY F(NMAX,MMAX)           
C                                                                       
C    N, M        ACTUAL DIMENSIONS USED FOR THE ARRAY                   
C                                                                       
C    TITL(I)     TITLE OF THE PLOTS (15*A4)                             
C    ILIN  = 1  EQUIDISTANT MESH FOR CONTOUR LINE VALUES                
C               DEFINED BY FMIN0, FMAX0, DELTA                          
C          > 1  (ILIN-1) CONTOUR LINES FOR SPECIFIC VALUES              
C               DEFINED BY ATL(I) WILL BE PLOTTED                       
C                                                                       
C    FMIN0       SMALLEST VALUE FOR A CONTOUR LINE  IF ILIN = 1         
C    FMAX0       LARGEST  VALUE FOR A CONTOUR LINE  IF ILIN = 1         
C    DELTA       INCREMENT BETWEEN CONTOUR LINES IF ILIN = 1            
C    ATL(I)      I=1...(NLIN-1) SPECIFIC VALUES FOR CONTOUR             
C                LINES   IF ILIN > 1                                    
C    IDEF        DEFINED DIMENSION OF ARRAY ATL                         
C                                                                       
C    RELX        ACTUAL WIDTH  (X DIRECTION) OF THE PLOT IN CM          
C    RELY        ACTUAL HEIGHT (Y DIRECTION) OF THE PLOT IN CM          
C                                                                       
C    IZERP = 0   BOTTOM LEFT CORNER (BLC) OF CONTOUR PLOT               
C                WILL BE AUTOMATICALLY ADJUSTED                         
C                (SHIFT TO THE RIGHT BY XW(RELX) + 2.)                  
C          = 1   BLC WILL BE SET AT (XZERP,YZERP) WITH                  
C                RESPECT TO AUTOMATICAL ORIGIN                          
C    XZERP ,     COORDINATES OF BLC IF  IZERP =1                        
C    YZERP                                                              
C                                                                       
C    IZERC = 0   BOTTOM LEFT CORNER (BLC) OF CLOUD PLOT                 
C                WILL BE AUTOMATICALLY ADJUSTED                         
C                (SHIFT TO THE RIGHT BY XW(RELX) + 2.)                  
C          = 1   BLC WILL BE SET AT (XZERC,YZERC) WITH                  
C                RESPECT TO AUTOMATICAL ORIGIN                          
C    XZERC ,     COORDINATES OF BLC IF  IZERC =1                        
C    YZERC                                                              
C                C A U T I O N :  TO AVOID OVERLAP OF PLOTS             
C                   CHECK XZERP,YZERP,XZERC,YZERC CAREFULLY             
C                                                                       
C    KPRINT = 0  NO REPRESENTATION OF F(I,K) ON THE PRINTER             
C           = 1  PRINT REPRESENTATION OF F(I,K)                         
C                                                                       
C    KPLOT  = 0  NO CONTOUR PLOT OF F(I,K)                              
C           = 1  CONTOUR PLOT OF F(I,K), DASHED LINES FOR NEG. F        
C           = 2  CONTOUR PLOT OF F(I,K), NO DASHED LINES                
C                                                                       
C    KCLOUD = 0  NO CLOUD GRAPH OF F(I,K)                               
C           = 1  CLOUD GRAPH OF F(I,K) USING HOMOGENEOUS SHADING        
C           = 2  CLOUD GRAPH OF F(I,K) USING CENTERED SHADING           
C           = 3  CLOUD GRAPH OF F(I,K) USING CONTIUOUS SHADING          
C           =-1  SAME AS  1  PLUS CONTOUR PLOT OVERLAYED                
C           =-2  SAME AS  2  PLUS CONTOUR PLOT OVERLAYED                
C           =-3  SAME AS  3  PLUS CONTOUR PLOT OVERLAYED                
C                                                                       
C    DIMENSIONS OF F(I,K) SHOULD NOT EXCEED 100X100                     
C                                                                       
C    CALLING SEQUENCE OF THE SYSTEM :                                   
C                                                                       
C                  CALL PLOTON(...)                                     
C    1 OR SEVERAL  CALL GRAFKH(...)                                     
C                  CALL FINISH                                          
C                                                                       
C                                                                       
      COMMON /SC/XW,YW,ACTV                                             
      COMMON /COLOR/ICOL,IDASH                                          
      COMMON /TIT/TITEL(15)                                             
      character*1 titl,titel                                            
      DIMENSION TITL(15),F(NMAX,MMAX),ATL(*)                         
      IF (KPRINT.GT.1.OR.KPRINT.LT.0) RETURN                            
      IF (KPLOT.GT.2.OR.KPLOT.LT.0) RETURN                              
      IF (IABS(KCLOUD).GT.3) RETURN                                     
      IF (ILIN.EQ.1) GOTO 60                                            
      FMIN=ATL(1)                                                       
      FMAX=FMIN                                                         
      ILIN1=ILIN-1                                                      
      DO 61 I=1,ILIN1                                                   
      IF(FMIN.GT.ATL(I)) FMIN=ATL(I)                                    
      IF(FMAX.LT.ATL(I)) FMAX=ATL(I)                                    
   61 CONTINUE                                                          
      DELTA=(FMAX-FMIN)/FLOAT(ILIN-2)                                   
      GOTO 62                                                           
   60 FMIN=FMIN0                                                        
      FMAX=FMAX0                                                        
   62 DO 30 I=1,15                                                      
   30 TITEL(I)=TITL(I)                                                  
      IDASH=1                                                           
      IF(KPLOT.EQ.2) IDASH=0                                            
C                                                                       
      AM=F(1,1)                                                         
      BM=AM                                                             
      DO 10 I=1,N                                                       
      DO 10 K=1,M                                                       
      IF (F(I,K).LT.BM) BM=F(I,K)                                       
      IF (F(I,K).GT.AM) AM=F(I,K)                                       
   10 CONTINUE                                                          
      IF (AM.NE.BM) GOTO 15                                             
      WRITE(66,20) AM                                                    
   20 FORMAT(//' THE VALUES OF THE ARRAY F(I,K)',                       
     1 ' ARE CONSTANT'//' AM = BM =',E12.4//                            
     2 ' NO PLOT GENERATED')                                            
      RETURN                                                            
   15 WRITE(66,1000) N,M,NMAX,MMAX,(TITL(I),I=1,15)                      
      IF(KPRINT.NE.0) WRITE(66,1001)                                     
      IF(KPLOT.NE.0) WRITE(66,1002)                                      
      IF(KCLOUD.GT.0) WRITE(66,1003)                                     
      IF(KCLOUD.LT.0) WRITE(66,1004)                                     
 1000 FORMAT('1  GRAPHICS PROGRAM BY K. HERMANN'//                      
     1 '   ARRAY SIZE OF F(I,K) WILL BE  (',I3,' X ',I3,                
     2 ')  OF  (',I3,' X ',I3,')'//'   TITLE = ',15A4/)                 
 1001 FORMAT('   PRINT OPTION')                                         
 1002 FORMAT('   PLOT  OPTION')                                         
 1003 FORMAT('   CLOUD  OPTION')                                        
 1004 FORMAT('   EXTENDED CLOUD OPTION')                                
c      IF (KPRINT.NE.0) CALL DRUCKS(N,M,TITL,AM,BM,F,NMAX,MMAX)         
      IF (KPLOT.EQ.0.AND.KCLOUD.EQ.0) RETURN                            
      IF (FMIN.LT.FMAX) GOTO 40                                         
      WRITE(66,1005) FMIN,FMAX                                           
 1005 FORMAT(//' FMIN =',E12.4,2X,'AND FMAX =',E12.4,'ARE IN',          
     1 'CONSISTENT'//' NO PLOT GENERATED')                              
      RETURN                                                            
   40 IF (FMIN.LE.AM.AND.FMAX.GE.BM) GOTO 42                            
      WRITE(66,1006) FMIN,FMAX,AM,BM                                     
 1006 FORMAT(//' FMIN =',E12.4,3X,'FMAX =',E12.4,3X,'NOT CONSIS',       
     1 'TENT WITH ARRAY BOUNDARIES  AM =',E12.4,3X,'BM =',E12.4         
     2 //' NO PLOT GENERATED')                                          
      RETURN                                                            
   42 ADEL=ABS(DELTA)                                                   
      IF (FMIN.LT.BM)  FMIN=FMIN+AINT((BM-FMIN)/ADEL)*ADEL              
      IF (FMAX.GT.AM)  FMAX=FMAX-AINT((FMAX-AM)/ADEL)*ADEL              
      IF ((FMAX-FMIN)*DELTA.GT.0.) GOTO 59                              
      WRITE(66,1007) FMIN,FMAX,DELTA                                     
 1007 FORMAT(////' BOUNDARIES NOT CONSISTENT'//' FMIN =',E13.6,         
     1 5X,'FMAX =',E13.6,5X,'DELTA =',E13.6//' NO PLOT GENERATED')      
      RETURN                                                            
   59 WIDTH=60.                                                         
      ICOL=0                                                            
      CALL NEWPEN(0)                                                    
      YW=RELY                                                           
      IF (YW.GT.WIDTH) YW=WIDTH                                         
      XW=YW*RELX/RELY                                                   
C                                                                       
      IF (ILIN.GT.1) then                                                    
      WRITE(*,1011) ILIN1,FMIN,FMAX,(ATL(I),I=1,ILIN1)                  
      WRITE(66,1011) ILIN1,FMIN,FMAX,(ATL(I),I=1,ILIN1)                  
 1011 FORMAT(/' FINAL PLOT PARAMETERS'/I3,' SPECIFIC CONTOUR',          
     1 ' VALUES BETWEEN FMIN = ',E12.4,'  AND FMAX = ',E12.4/           
     2 (1X,4E12.4))                                                    
      else IF(ILIN.EQ.1) then
      WRITE(66,1008) FMIN,FMAX,DELTA                       
      WRITE(*,1008) FMIN,FMAX,DELTA                       
 1008 FORMAT(/' FINAL PLOT PARAMETERS',/,
     *' LOWEST CONTOUR VALUE = ', E12.4,/,
     *' HIGHEST CONTOUR VALUE =',E12.4,/,
     *' DELTA =                ',E12.4)     
      end if
      WRITE(66,1014) AM,BM,XW,YW                                         
      WRITE(*,1014) AM,BM,XW,YW                                         
 1014 FORMAT(' ARRAY BOUNDARIES:  MAX:',E12.4,3X,'MIN:',E12.4/         
     1 ' PLOT SIZE WILL BE',F10.2,'  BY',F7.2,'  CM')                   
      IF (KPLOT.EQ.1) WRITE(66,1009)                                     
      IF (KPLOT.EQ.2) WRITE(66,1010)                                     
 1009 FORMAT(' DASHED LINES PROVIDED')                                  
 1010 FORMAT(' NO DASHED LINES PROVIDED')                               
      IF(IZERP.NE.0.AND.KPLOT.NE.0) WRITE(66,1012) XZERP,YZERP           
 1012 FORMAT(' ORIGIN OF CONPLOT READJUSTED AT (',F8.2,',',F8.2,')')    
      IF (IZERP.NE.0.AND.KPLOT.NE.0) CALL PLOT(XZERP,YZERP,-3)          
      IF (KPLOT.NE.0) CALL CONPLT(F,NMAX,MMAX,N,M,ILIN,FMIN,            
     1 FMAX,DELTA,ATL,IDEF,0)                                           
      IF(IZERC.NE.0.AND.KCLOUD.NE.0) WRITE(66,1013) XZERC,YZERC          
 1013 FORMAT(' ORIGIN OF CLOUD READJUSTED AT (',F8.2,',',F8.2,')')      
      IF (IZERC.NE.0.AND.KCLOUD.NE.0) CALL PLOT(XZERC,YZERC,-3)         
      RETURN                                                            
      END                                                               
      SUBROUTINE DRUCKS(NABS,NORD,TITEL,AM0,BM0,F,NDEF,MDEF)            
C                                                                       
C    ZAHLENAUSGABE EINES NABS X NORD FELDES AUF DEM SCHNELLDRUCKER      
C    NEUES PROGRAMM MIT VARIABLEM FORMAT                                
C                                                                       
C    DAS FELD F(NABS,NORD) WIRD AUF WERTE ZWISCHEN 0 UND 100 NORMIERT   
C    UND ALS INTEGERFELD ZEILENWEISE AUSGEGEBEN                         
C                                                                       
C    NORD = ZAHL DER DRUCKZEILEN                                        
C    NABS = (HALBE) ZAHL DER DRUCKSTELLEN PRO ZEILE                     
C                                                                       
C    TITEL = LITERALFELD, DAS ZUR UEBERSCHRIFT VERWENDET WIRD           
C                                                                       
C    DER WERT VON NMAX NUSS MIT DER DIMENSION VON  IN  IDENTISCH SEIN   
C                                                                       
      DIMENSION F(NDEF,MDEF),TITEL(15),IN(60),KO(102)                   
      DIMENSION FORM(62)                                                
      character*1 titel                                                 
      character*8 form,f1,f2,f3,f4,f5,f6,f7,f8                          
      DATA F1,F2,F3,F4/'(2H +,  ','I2,     ','2X,     ','1H+)    '/     
      DATA F5,F6,F7,F8/'2H++,   ','        ','(2H  ,  ',')       '/     
      DATA NMAX/60/                                                     
C                                                                       
      AM=AM0                                                            
      BM=BM0                                                            
      IF (AM.NE.BM) GOTO 25                                             
      WRITE(66,35) (TITEL(I),I=1,15),AM                                  
   35 FORMAT(1H1,15A4//' THE VALUES OF THE WAVEFUNCTION COM',           
     1 'BINATION IN THIS PLANE ARE CONSTANT'//' AM = BM =',E12.4//      
     2 ' NO PRINT GENERATED')                                           
      RETURN                                                            
   25 IF (AM*BM.GT.0.) BM=0.                                            
      NZERO=-100.*BM/(AM-BM)                                            
      IF (BM.GT.AM) AM=BM0                                              
      QT=(AM-BM)/100.                                                   
      DO 5 I=1,101                                                      
    5 KO(I)=0                                                           
C                                                                       
C    INTEGER UMWANDLUNG UND AUSDRUCK                                    
C                                                                       
   30 WRITE(66,1000) (TITEL(I),I=1,15),AM,BM,BM0,NZERO                   
      WRITE(66,1002) BM,QT,BM,QT                                         
      IREP=1                                                            
      IE=0                                                              
   65 NN=NMAX+2                                                         
      DO 70 I=2,NN                                                      
   70 FORM(I)=F6                                                        
      FORM(1)=F1                                                        
      IF (IREP.NE.1) FORM(1)=F7                                         
      IA=IE+1                                                           
      IE=MIN0(NABS,IA+NMAX-1)                                           
      N=IE-IA+3                                                         
      FORM(N)=F4                                                        
      IF(IE.NE.NABS) FORM(N)=F8                                         
      N=N-1                                                             
      DO 55 I=2,N                                                       
   55 FORM(I)=F5                                                        
      WRITE(66,FORM)                                                     
      DO 15 J=1,NORD                                                    
      JH=NORD+1-J                                                       
      NLIN=1                                                            
C                                                                       
   40 DO 20 I=IA,IE                                                     
      K=I-IA+2                                                          
      FORM(K)=F3                                                        
      NP=100.*(F(I,JH)-BM)/(AM-BM)                                      
      KO(NP+1)=KO(NP+1)+1                                               
      IF (NP.EQ.0) GOTO 20                                              
      IN(NLIN)=NP                                                       
      FORM(K)=F2                                                        
      NLIN=NLIN+1                                                       
   20 CONTINUE                                                          
   45 NLIN=NLIN-1                                                       
      IF (NLIN.EQ.0) GOTO 46                                            
      WRITE(66,FORM) (IN(JJ),JJ=1,NLIN)                                  
      GOTO 15                                                           
   46 WRITE(66,FORM)                                                     
   15 CONTINUE                                                          
      DO 60 I=2,N                                                       
   60 FORM(I)=F5                                                        
      WRITE(66,FORM)                                                     
      IF(IE.EQ.NABS) GOTO 80                                            
      IREP=IREP+1                                                       
      WRITE(66,1001) IREP                                                
      GOTO 65                                                           
   80 WRITE(66,1003)                                                     
      WRITE(66,1004) KO(1)                                               
      WRITE(66,1004) (KO(I),I=2,101)                                     
      RETURN                                                            
 1000 FORMAT(1H1,15A4//' 100 (**) CORRESPONDS TO ',1PE12.4,4X,          
     1 '  0 (BLANK) CORRESPONDS TO',1PE12.4,4X,'MINIMUM =',1PE12.4,     
     2 4X,'ZERO AT',I3/)                                                
 1001 FORMAT(////////' PAGE NO.',I3/)                                   
 1002 FORMAT(' N  IS :  ',1PE12.5,' + ',1PE12.5,' X N  .LE.A(I,J)',     
     1'.LT.  ',1PE12.5,' + ',1PE12.5,' X (N+1)'/)                       
 1003 FORMAT(////' STATISTICS :'/)                                      
 1004 FORMAT(3X,10I6)                                                   
      END                                                               
      SUBROUTINE CONPLT(A,NMAX,MMAX,N,M,ILIN,A0,A1,DA,                  
     1 ATL,IDEF,IP)                                                     
C                                                                       
C    CONTOUR PLOT PROGRAMM     4. VERSION  CLAUSTHAL                    
C                                                                       
C    INTERFACING WITH GRAFIKH  X - Y  INTERCHANGE                       
C                                                                       
C    AUTOR:    K. HERMANN                                               
C            INST. F. THEOR. PHYSIK B ,  TU CLAUSTHAL                   
C                                                                       
C    IP    = 0    KEINE LINIEN-DRUCKAUSGABE                             
C          = 1    LINIEN TITEL-AUSDRUCK                                 
C          = 2    AUSDRUCK ALLER LINIEN-KOORDINATEN                     
C                                                                       
C                                                                       
      PARAMETER (NXDIM=200)                                             
      PARAMETER (NYDIM=150)                                             
      COMMON /LINE/XL(1000),YL(1000),GSX,GSY,IPRI                       
      COMMON /SC/XW,YW,AT                                               
      DIMENSION A(NMAX,MMAX),ATL(*)                                  
      LOGICAL PX(NXDIM,NYDIM),PY(NXDIM,NYDIM)                           
      IPRI=IP                                                           
      DY=XW/FLOAT(N-1)                                                  
      DX=YW/FLOAT(M-1)                                                  
      GSX=DX/1000.                                                      
      GSY=DY/1000.                                                      
      NLMAX=1000                                                        
      A11=A1+ABS(DA)*.5                                                 
C                                                                       
      IF (IPRI.GT.0) WRITE(66,998)                                       
  998 FORMAT(1H1,' LINIENAUSGABE DES CONTOUR PLOT',                     
     1' PROGRAMMS (K. HERMANN, JULI 1980)'//)                           
      IF (ILIN.GT.1) NLIN=0                                             
      IF (ILIN.EQ.1) AT=A0-DA                                           
   60 IF (ILIN.GT.1) GOTO 61                                            
      AT=AT+DA                                                          
      IF (ABS(AT/DA).LT.1.E-4) AT=0.                                    
      IF (AT.GT.A11) GOTO 999                                           
      GOTO 62                                                           
   61 NLIN=NLIN+1                                                       
      IF (NLIN.EQ.ILIN) GOTO 999                                        
      AT=ATL(NLIN)                                                      
   62 IF (IPRI.GT.0)  WRITE(66,1000) AT                                  
 1000 FORMAT(/,' LINIENSUCHWERT  F =',F10.7)                            
C                                                                       
C    LINIEN VORSUCHE                                                    
C                                                                       
      NPTOT=0                                                           
      MH=M-1                                                            
      DO 10 I=1,N                                                       
      DO 10 K=1,MH                                                      
      PX(I,K)=.FALSE.                                                   
      IF ((AT-A(I,K))*(AT-A(I,K+1)).GT.0.) GOTO 10                      
      IF (AT.LE.A(I,K).AND.AT.LE.A(I,K+1)) GOTO 10                      
      PX(I,K)=.TRUE.                                                    
      NPTOT=NPTOT+1                                                     
   10 CONTINUE                                                          
C                                                                       
      MH=N-1                                                            
      DO 20 I=1,MH                                                      
      DO 20 K=1,M                                                       
      PY(I,K)=.FALSE.                                                   
      IF ((AT-A(I,K))*(AT-A(I+1,K)).GT.0.) GOTO 20                      
      IF (AT.LE.A(I,K).AND.AT.LE.A(I+1,K)) GOTO 20                      
      PY(I,K)=.TRUE.                                                    
      NPTOT=NPTOT+1                                                     
   20 CONTINUE                                                          
C                                                                       
C    LINIENSUCHE ANFANG                                                 
C                                                                       
      IF (NPTOT.LE.1) GOTO 60                                           
C                                                                       
C    RAND OBEN                                                          
      IFA=1                                                             
      KT=0                                                              
    1 KT=KT+1                                                           
      IF (KT.EQ.M)  GOTO 11                                             
      IF (.NOT.PX(N,KT))  GOTO 1                                        
      NL=0                                                              
      I=N                                                               
      K=KT                                                              
      GOTO 233                                                          
C                                                                       
C    RAND LINKS                                                         
   11 IFA=2                                                             
      IT=0                                                              
    2 IT=IT+1                                                           
      IF (IT.EQ.N)  GOTO 12                                             
      IF (.NOT.PY(IT,1))  GOTO 2                                        
      NL=0                                                              
      I=IT                                                              
      K=0                                                               
      GOTO 203                                                          
C                                                                       
C    RAND RECHTS                                                        
   12 IFA=3                                                             
      IT=0                                                              
    3 IT=IT+1                                                           
      IF (IT.EQ.N)  GOTO 13                                             
      IF (.NOT.PY(IT,M))  GOTO 3                                        
      NL=0                                                              
      I=IT                                                              
      K=M                                                               
      GOTO 223                                                          
C                                                                       
C    RAND UNTEN UND INNERES  (PX)                                       
   13 IFA=4                                                             
      IT=0                                                              
    6 IT=IT+1                                                           
      IF (IT.EQ.N)  GOTO 14                                             
      KT=0                                                              
    4 KT=KT+1                                                           
      IF (KT.EQ.M)  GOTO 6                                              
      IF (.NOT.PX(IT,KT))  GOTO 4                                       
      NL=0                                                              
      I=IT-1                                                            
      K=KT                                                              
      GOTO 213                                                          
C                                                                       
C    INNERES  (PY)                                                      
   14 IFA=5                                                             
      KT=1                                                              
    7 KT=KT+1                                                           
      IF (KT.EQ.M)  GOTO 60                                             
      IT=0                                                              
    5 IT=IT+1                                                           
      IF (IT.EQ.N)  GOTO 7                                              
      IF (.NOT.PY(IT,KT))  GOTO 5                                       
      NL=0                                                              
      I=IT                                                              
      K=KT-1                                                            
      GOTO 203                                                          
C                                                                       
C                                                                       
C    AUSGANG EINGANG   RECHTS                                           
C                                                                       
  103 NSA=1                                                             
      IF (NSA.EQ.NSE) GOTO 200                                          
  203 NL=NL+1                                                           
      Q=(A(I,K+1)-AT)/(A(I,K+1)-A(I+1,K+1))                             
      XL(NL)=DX*FLOAT(K)                                                
      YL(NL)=DY*(FLOAT(I-1)+Q)                                          
      IF (.NOT.PY(I,K+1)) GOTO 50                                       
      PY(I,K+1)=.FALSE.                                                 
      NPTOT=NPTOT-1                                                     
      K=K+1                                                             
      IF (K.EQ.M) GOTO 50                                               
      IF (NL.EQ.NLMAX)  CALL LINEP(NL,.TRUE.)                           
      NSE=3                                                             
      GOTO 99                                                           
C                                                                       
C    AUSGANG EINGANG   LINKS                                            
C                                                                       
  123 NSA=3                                                             
      IF (NSA.EQ.NSE) GOTO 220                                          
  223 NL=NL+1                                                           
      Q=(A(I,K)-AT)/(A(I,K)-A(I+1,K))                                   
      XL(NL)=DX*FLOAT(K-1)                                              
      YL(NL)=DY*(FLOAT(I-1)+Q)                                          
      IF (.NOT.PY(I,K)) GOTO 50                                         
      PY(I,K)=.FALSE.                                                   
      NPTOT=NPTOT-1                                                     
      K=K-1                                                             
      IF (K.LT.1) GOTO 50                                               
      IF (NL.EQ.NLMAX)  CALL LINEP(NL,.TRUE.)                           
      NSE=1                                                             
      GOTO 99                                                           
C                                                                       
C    AUSGANG EINGANG   OBEN                                             
C                                                                       
  133 NSA=4                                                             
      IF (NSA.EQ.NSE) GOTO 210                                          
  213 NL=NL+1                                                           
      Q=(A(I+1,K)-AT)/(A(I+1,K)-A(I+1,K+1))                             
      XL(NL)=DX*(FLOAT(K-1)+Q)                                          
      YL(NL)=DY*FLOAT(I)                                                
      IF (.NOT.PX(I+1,K)) GOTO 50                                       
      PX(I+1,K)=.FALSE.                                                 
      NPTOT=NPTOT-1                                                     
      I=I+1                                                             
      IF (I.EQ.N) GOTO 50                                               
      IF (NL.EQ.NLMAX)  CALL LINEP(NL,.TRUE.)                           
      NSE=2                                                             
      GOTO 99                                                           
C                                                                       
C    AUSGANG EINGANG   UNTEN                                            
C                                                                       
  113 NSA=2                                                             
      IF (NSA.EQ.NSE) GOTO 230                                          
  233 NL=NL+1                                                           
      Q=(A(I,K)-AT)/(A(I,K)-A(I,K+1))                                   
      XL(NL)=DX*(FLOAT(K-1)+Q)                                          
      YL(NL)=DY*FLOAT(I-1)                                              
      IF (.NOT.PX(I,K)) GOTO 50                                         
      PX(I,K)=.FALSE.                                                   
      NPTOT=NPTOT-1                                                     
      I=I-1                                                             
      IF (I.LT.1) GOTO 50                                               
      IF (NL.EQ.NLMAX)  CALL LINEP(NL,.TRUE.)                           
      NSE=4                                                             
   99 AM=(A(I,K)+A(I+1,K)+A(I,K+1)+A(I+1,K+1))/4.                       
      GOTO (100,110,120,130),NSE                                        
C                                                                       
C    RECHTSKARUSSEL                                                     
C                                                                       
  100 IF ((AM-AT)*(A(I,K+1)-AT))  110,102,103                           
  102 IF (AT.LT.AM.OR.AT.LT.A(I,K+1)) GOTO 103                          
      IF (AM.EQ.A(I,K+1)) GOTO 103                                      
C                                                                       
  110 IF ((AM-AT)*(A(I,K)-AT))  120,112,113                             
  112 IF (AT.LT.AM.OR.AT.LT.A(I,K)) GOTO 113                            
      IF (AM.EQ.A(I,K)) GOTO 113                                        
C                                                                       
  120 IF ((AM-AT)*(A(I+1,K)-AT))  130,122,123                           
  122 IF (AT.LT.AM.OR.AT.LT.A(I+1,K)) GOTO 123                          
      IF (AM.EQ.A(I+1,K)) GOTO 123                                      
C                                                                       
  130 IF ((AM-AT)*(A(I+1,K+1)-AT))  100,132,133                         
  132 IF (AT.LT.AM.OR.AT.LT.A(I+1,K+1)) GOTO 133                        
      IF (AM.EQ.A(I+1,K+1)) GOTO 133                                    
      GOTO 100                                                          
C                                                                       
C    LINKSKARUSSEL                                                      
C                                                                       
  200 IF ((AM-AT)*(A(I+1,K+1)-AT))  210,202,203                         
  202 IF (AT.LT.AM.OR.AT.LT.A(I+1,K+1)) GOTO 203                        
      IF (AM.EQ.A(I+1,K+1)) GOTO 203                                    
C                                                                       
  210 IF ((AM-AT)*(A(I+1,K)-AT))  220,212,213                           
  212 IF (AT.LT.AM.OR.AT.LT.A(I+1,K)) GOTO 213                          
      IF (AM.EQ.A(I+1,K)) GOTO 213                                      
C                                                                       
  220 IF ((AM-AT)*(A(I,K)-AT))  230,222,223                             
  222 IF (AT.LT.AM.OR.AT.LT.A(I,K)) GOTO 223                            
      IF (AM.EQ.A(I,K)) GOTO 223                                        
C                                                                       
  230 IF ((AM-AT)*(A(I,K+1)-AT))  200,232,233                           
  232 IF (AT.LT.AM.OR.AT.LT.A(I,K+1)) GOTO 233                          
      IF (AM.EQ.A(I,K+1)) GOTO 233                                      
      GOTO 200                                                          
C                                                                       
C    LINIENAUSGANG UND VERARBEITUNG                                     
C                                                                       
   50 CALL LINEP(NL,.FALSE.)                                            
      IF (NPTOT.LE.0)  GOTO 60                                          
      GOTO (1,2,3,4,5),IFA                                              
  999 CALL PLLINE(0)                                                    
      RETURN                                                            
      END                                                               
      SUBROUTINE LINEP(N,BUFFUL)                                        
      COMMON /LINE/XL(1000),YL(1000),GSX,GSY,IPRI                       
      LOGICAL   BUFFUL                                                  
      IF (N.EQ.1) RETURN                                                
C                                                                       
C    AUSSCHLANKEN                                                       
C                                                                       
      IV=0                                                              
      NW=N                                                              
      DO 10 I=2,N                                                       
      IF(ABS(XL(I)-XL(I-1)).GT.GSX.OR.ABS(YL(I)-YL(I-1)).GT.GSY)GOTO 15 
      IV=IV+1                                                           
      NW=NW-1                                                           
   15 XL(I-IV)=XL(I)                                                    
      YL(I-IV)=YL(I)                                                    
   10 CONTINUE                                                          
      IF (IPRI.GT.0) WRITE(66,1000) N,NW                                 
      IF (IPRI.GT.1) WRITE(66,1001) (YL(I),XL(I),I=1,NW)                 
 1000 FORMAT(5X,' ORIGINALLINIE',3X,I5,' PUNKTE',10X,                   
     1'REDUKTION',5X,I5,' PUNKTE')                                      
 1001 FORMAT((10X,5(' (',F9.5,',',F9.5,')')))                           
      XE=XL(N)                                                          
      YE=YL(N)                                                          
      IF (NW.GT.1)  CALL PLLINE(NW)                                     
      N=NW                                                              
      IF (.NOT.BUFFUL)  RETURN                                          
      N=1                                                               
      XL(1)=XE                                                          
      YL(1)=YE                                                          
      RETURN                                                            
      END                                                               
      SUBROUTINE PLLINE(N)                                              
      DIMENSION STRING(15)                                              
      COMMON /LINE/XL(1000),YL(1000),GSX,GSY,IPRI                       
      COMMON /SC/XW,YW,ACTV                                             
      COMMON /TIT/TITL(15)                                              
      COMMON /COLOR/ICOL,IDASH                                          
      character*1 blk                                                   
      character*1 titl,string                                           
      DATA BLK/' '/                                                     
C                                                                       
C   PLOT UNTERPROGRAMM                                                  
C                                                                       
C    INTERFACING WITH GRAFIKH  X - Y  INTERCHANGE                       
C                                                                       
      DO 110 I=1,15                                                     
  110 STRING(I)=TITL(I)                                                 
      FFUL=.035*AMAX1(XW,YW)                                            
      FEMP=FFUL/3.                                                      
      IF (N.GT.0) GOTO 100                                              
C                                                                       
C  (A)  RAHMENZEICHNUNG BEI VORHANDENEM NULLPUNKT                       
C                                                                       
C       HOEHE (Y) = YW  ,  BREITE (X) = XW                              
C                                                                       
      IF (ICOL.NE.0) CALL NEWPEN(0)                                     
      ICOL=0                                                            
      CALL PLOT(0.,YW,3)                                                
      NONB=15                                                           
      DO 10 I=1,15                                                      
      IF (TITL(16-I).NE.BLK) GOTO 11                                    
   10 NONB=NONB-1                                                       
      GOTO 12                                                           
   11 NCAR=NONB*4                                                       
      CAR=NCAR                                                          
      HGT=XW/CAR                                                        
      IF (HGT.GT..56) HGT=.56                                           
   12 CALL PLOT(0.,YW,3)                                                
      CALL PLOT(XW,YW,2)                                                
      CALL PLOT(XW,0.,2)                                                
      CALL PLOT(0.,0.,2)                                                
      CALL PLOT(0.,YW,2)                                                
      CALL PLOT(XW,0.,-3)                                               
      RETURN                                                            
C                                                                       
C  (B)   LINIENZEICHNUNG                                                
C                                                                       
  100 CALL PLOT(YL(1),XL(1),3)                                          
      IF (ACTV) 1,2,3                                                   
    1 ICOL0=0                                                           
      IF (IDASH.EQ.0) ICOL0=1                                           
      GOTO 4                                                            
    2 ICOL0=1                                                           
      IF (IDASH.EQ.0) ICOL0=1                                           
      GOTO 4                                                            
    3 ICOL0=0                                                           
    4 IF (ICOL0.NE.ICOL) CALL NEWPEN(ICOL0)                             
      ICOL=ICOL0                                                        
      IF (ACTV)  80,60,40                                               
   40 DO 50 I=2,N                                                       
      CALL PLOT(YL(I),XL(I),2)                                          
   50 CONTINUE                                                          
      RETURN                                                            
   60 IF (IDASH.EQ.0) GOTO 40                                           
      DO 70 I=2,N                                                       
      X=(XL(I)+XL(I-1))*.5                                              
      Y=(YL(I)+YL(I-1))*.5                                              
      CALL PLOT (Y,X,2)                                                 
      CALL PLOT (YL(I),XL(I),3)                                         
   70 CONTINUE                                                          
      RETURN                                                            
   80 IF (IDASH.EQ.0) GOTO 40                                           
      I=1                                                               
      XLEN=FFUL                                                         
      IPEN=2                                                            
   14 I=I+1                                                             
      IF (I.GT.N) RETURN                                                
      XLE=SQRT((XL(I)-XL(I-1))*(XL(I)-XL(I-1))+(YL(I)-YL(I-1))*         
     1 (YL(I)-YL(I-1)))                                                 
      XLE0=XLE                                                          
   16 XLE=XLE-XLEN                                                      
      IF (XLE.LT.0.) GOTO 13                                            
      X=XL(I)+(XL(I-1)-XL(I))*XLE/XLE0                                  
      Y=YL(I)+(YL(I-1)-YL(I))*XLE/XLE0                                  
   17 CALL PLOT(Y,X,IPEN)                                               
      IF (IPEN.EQ.2) GOTO 15                                            
      IPEN=2                                                            
      XLEN=FFUL                                                         
      GOTO 16                                                           
   15 IPEN=3                                                            
      XLEN=FEMP                                                         
      GOTO 16                                                           
   13 CALL PLOT(YL(I),XL(I),IPEN)                                       
      XLEN=-XLE                                                         
      GOTO 14                                                           
      RETURN                                                            
      END                                                               
      SUBROUTINE PLOT(X,Y,IPEN)                                         
      CHARACTER *2 IPR, IND1(6)                                         
      integer polyl(4)
      DIMENSION IND(6,2)                                                
        save num,polyl,ind,ind1,icount                                         
      DATA NUM/0/,icount/0/                                                       
      IX=INT(X*100)                                                     
      IY=INT(Y*100)                                                     
      IPR='IK'                                                          
      IF(IPEN.EQ.3) IPR='HK'                                            
      IF(IPEN.LT.2) GOTO 10                                             
c..   display                                                           
      if(ipen.eq.3) then                                                
        call smove(x,y)
c            polyl(1)=ix                                                 
c            polyl(2)=iy                                                 
      else                                                              
        call sline(x,y)
c            polyl(3)=ix                                                 
c            polyl(4)=iy                                                 
c            call vline(status,340-polyl(2)/6,polyl(1)/5,340-polyl(4)    
c     */6,polyl(3)/5,7)                                                  
c            polyl(1)=ix                                                 
c            polyl(2)=iy                                                 
      end if                                                            
c..   ps drucker                                                                       
      NUM=NUM+1                                                         
      IND(NUM,1)=IX                                                     
      IND(NUM,2)=IY                                                     
      IND1(NUM)=IPR                                                     
      IF(NUM.NE.6) RETURN                                               
      icount=icount+1
             if(icount.gt.100.) then 
      do 9292 i=1,6
      if(ind1(i).eq.'HK') then
      WRITE(20,1) ((IND(iI,J),J=1,2),IND1(iI),iI=1,i-1)                      
       print*,'plot1',((IND(iI,J),J=1,2),IND1(iI),iI=1,i-1)                                  write(20,*) ' stroke' 
      WRITE(20,1) ((IND(iI,J),J=1,2),IND1(iI),iI=i,6)                      
       print*,'plot2',((IND(Ii,J),J=1,2),IND1(iI),iI=1,6)                                  icount=0
        goto 9293
       end if
 9292 continue
             end if
      WRITE(20,1) ((IND(I,J),J=1,2),IND1(I),I=1,6)  
       print*,'plot3',((IND(I,J),J=1,2),IND1(I),I=1,6)                             
 9293 continue
C   1  FORMAT(6(I5,1H/,I4,A2))                                           
   1  FORMAT(6(I5,' ',I4,' ',A2))                                           
      NUM=0                                                             
      RETURN                                                            
  10  IF(NUM.EQ.0) GOTO 12                                              
      WRITE(20,1) (IND(I,1),ind(i,2),IND1(I),I=1,NUM)                   
       print*,'plot4',((IND(I,J),J=1,2),IND1(I),I=1,NUM)                             
      NUM=0                                                             
  12  IF(IPEN.EQ.0) GOTO 15                                             
      RETURN                                                            
   15 IX=IX/100                                                         
c      WRITE(20,16) IX                                                   
   16 FORMAT(3H HF,I2)                                                  
      RETURN                                                            
      END                                                               
      SUBROUTINE NEWPEN(IP)                                             
      P=IP+1.01                                                         
      CALL PLOT(P,0.,0)                                                 
      RETURN                                                            
      END                                                               
C***********************************************************************
      subroutine psinit(pfname)
      character*80 pfname
      open(20,file=pfname)                                               
      write(20,'(a)') '%!PS-Adobe-2.0'
      write(20,*) '/CMM { 0.283465 mul} def'
      write(20,*) '/IK { CMM exch CMM exch lineto} def '
      write(20,*) '/HK { CMM exch CMM exch moveto} def '
      write(20,1) 
  1   format('/CM { 28.3465 mul} def',/,
     *       '/T { CM exch CM exch translate} def',/,
     *       '/RL { CM exch CM exch rlineto} def',/,
     *       '/RM { CM exch CM exch rmoveto} def',/,
     *       '/L { CM exch CM exch lineto} def',/,
     *       '/M { CM exch CM exch moveto} def',/
     *       '/BOX {stroke newpath  M ',/,
     *       'length 0 rlineto 0 hight rlineto length neg 0 rlineto ',/,
     *       'closepath 1 setgray fill 0 setgray } def')
      call setsz(40,0,30,0) 
      write(20,*) 'newpath    200 CMM 200 CMM translate'
      return
      end 
C***********************************************************************
      subroutine psclos
      write(20,*) 'stroke   showpage'
      close(20)
      return
      end
C***********************************************************************
      subroutine closesc
      call pgend
      return
      end 
C***********************************************************************
      subroutine savecl
c
      call pgbegin(0,'/XW',1,1)
      call pgvsize(0.,10.,0.,8.)
      call pgwindow(0.,25.,0.,20.)
      return
      END
C***********************************************************************
      subroutine smove(x,y)
      call pgmove(x,y)
      return
      end
C***********************************************************************
      subroutine sline(x,y)
      call pgdraw(x,y)
      return
      end
C***********************************************************************
      character function choice(name)
      character name(80)
      do 10 i=1,80
      if(name(i).ne.' ') then
      choice=name(i)
      return
      end if
  10  continue
      choice=' '
      return
      end
C***********************************************************************
      SUBROUTINE DIRPL
      CHARACTER ich,name2(80),name1 ,choice
      CHARACTER*80 NAME 
      dimension x1(2),y1(2)
      save ih
      data ih /40/
c
 5    WRITE(*,1)
  1   format(    ' enter   t   for text',/,
     *           '         s   for textsize',/,
     *           '         l   for line drawing',/,
     *           '         e   to return')
      read(*,4) name2
      name1=choice(name2)           
  4   format(80a1)
c
c   textsize
c
      if(name1.eq.'s'.or.name1.eq.'S') then
        write(*,3)
  3     format(' enter text hight and width (0.1 mm):',$)
        read(*,*) ih,iw
        call setsz(ih,0,iw,0)
C Establish one of the three prepared fonts as the current font.
        call pgsch(ih/40.)
c
c   text
c
      else if(name1.eq.'t'.or.name1.eq.'T') then
        write(*,*) ' enter text, then position cursor and',
     *             ' press left mouse button:'   
      read(*,2) name
   2  format(a80)
      do 20 i=80,1,-1
  20  if(name(i:i).ne.' ') goto 30
  30  istring_length=i
      x=5.
      y=5.
      call pgcurse(x,y,ich)
      call pgtext(x,y,name)
      call tbox(name,i,0,ih,x-0.1,y-0.1)
      call psplot(x,y,-1)
      call text(name,i,0)
c
c    line drawing
c
      else if(name1.eq.'l'.or.name1.eq.'L') then
        write(*,*) ' position mouse, add point with left button'
        write(*,*) '                 delete point with middle button'
        write(*,*) '                 exit with right button' 
        call pglcur(2,0,x1,y1)
        write(*,*) ' line runs from:',x1(1),y1(1)
        write(*,*) '           to:  ',x1(2),y1(2)
c        write(*,*) ' enter 4 new values:'
c        read(*,*) x1(1),y1(1),x1(2),y1(2)
c
        call psplot(x1(1),y1(1),-1) 
        call psplot(x1(2),y1(2),1)
c         
      else if(name1.eq.'e'.or.name1.eq.'E') then
        return
      end if
        goto 5
      END   
C***********************************************************************
      SUBROUTINE SETSZ(IH,ID,IW,N)
C
C     LEGT BESCHRIFTUNGSGRSSE UND NEIGUNG FEST
C
      DATA JH,JD,JW,JN/40,0,30,0/
      IF(IH.EQ.0) GOTO 10
      IF(IH.LT.0) GOTO 15
      JH=IH
   15 IF(ID.LT.0) GOTO 16   
      JD=ID
   16 IF(IW.LT.0) GOTO 17
      JW=IW
   17 IIH=IABS(IH)
      IID=IABS(ID)
      IIW=IABS(IW)
c     define standard font , fontsize is unclear to me
      write(20,100) iiw/2.0,0.,0.,iih/2.0,0.,0.
 100  format('/Courier-Bold findfont [',6f5.1,'] makefont setfont')
c      WRITE(2,1) IIH,IID,IIW,N
      RETURN
   10 continue
c     WRITE(2,1) JH,JD,JW,JN
      RETURN
   1  FORMAT(' Z',3I3,' %',I1)
      END                
C***********************************************************************
      SUBROUTINE psPLOT(X,Y,I)
C
C     I=0,1, : plot
C     I.LT.0 : move
C
      IF(I.LT.0) THEN
         WRITE(20,100) x,y
 100     format(f6.2,f7.2,' M')    
         RETURN
      end if  
         WRITE(20,103) x,y
 103     format(f6.2,f7.2,' L')    
         RETURN
c      ENDIF
      END                   
C***********************************************************************
      SUBROUTINE TEXT(T,ij,idir)  
      CHARACTER*1 T(40)
      if(idir.ne.0) write(20,*) idir,' rotate'
      write(20,*) '(',(t(i),i=1,ij),') show'   
      if(idir.ne.0) write(20,*) -idir,' rotate'
cc      WRITE(2,1)(T(J),J=1,ij)
cc  1   FORMAT(' B',40A1)
      RETURN
      END
C***********************************************************************
      SUBROUTINE Tbox(T,ij,idir,ih,x,y)  
      CHARACTER*1 T(40)
c      if(idir.ne.0) write(20,*) idir,' rotate'
      write(20,*) '(',(t(i),i=1,ij),') stringwidth pop'
      write(20,*) '/length exch 0.2 CM add def '
      write(20,*) '/hight {',ih/2,' 0.0 CM add} def' 
      write(20,*) x,y,' BOX'   
c      if(idir.ne.0) write(20,*) -idir,' rotate'
cc      WRITE(2,1)(T(J),J=1,ij)
cc  1   FORMAT(' B',40A1)
      RETURN
      END

